<title>My Jobs - Best Leearning</title>
@extends('user.layouts.master')
@section('css')
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css?v=1.1.0" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/bttn.css" type="text/css">
    <style>
        .shadow-sm {
            display: none !important;
        }

        .table th {
            background-color: rgba(250, 250, 250, 1); 
            color: #000066; 
            font-size: 12px;
        }
    
        .table-no-vertical-border th,
        .table-no-vertical-border td {
            border-left: none;  
            border-right: none; 
            border-color: rgba(0, 0, 0, 0.1); 
        }
        .table tbody tr:hover {
            cursor: pointer;
            opacity: 0.6;
        }
        
        .arv-job {
           color: blue;
           font-weight:bold;
        }
        
    </style>
@endsection

@section('user-content')
<section>
    <div class="card mt-2">
        <div class="card-header">
    <div class="card-title text-center" style="font-weight: 500; color: #2ECC71; font-size: 20px;">Post New Ads</div>
   
        </div>
        <div class="card-body">
           <div class="card-body">
            <h5 class="card-title">Add Advertisement</h5>
         <form action="{{route('user.ads-store')}}" method="POST" class="row g-3 needs-validation" onsubmit="return validateForm()">
                @csrf
                <!-- Ads Title -->
                <div class="col-md-3">
                    <label for="adsTitle" class="form-label">Ads Title</label>
                    <input type="text" id="adsTitle" name="ads_title" class="form-control" placeholder="Enter ad title" required>
                    <div class="invalid-feedback">
                        Please provide a title for the ad.
                    </div>
                </div>
            
                <!-- Ads Link -->
                <div class="col-md-3">
                    <label for="adsLink" class="form-label">Ads Link (Direct Link)</label>
                    <input type="text" id="adsLink" name="adsLink" class="form-control" placeholder="Enter ad link" required>
                    <div class="invalid-feedback">
                        Please provide a valid URL.
                    </div>
                </div>
            
                <!-- Worker -->
                <div class="col-md-3">
                    <label for="worker" class="form-label">Worker</label>
                    <input 
                        type="number" 
                        id="worker" 
                        name="worker" 
                        class="form-control" 
                        placeholder="Enter number of workers" 
                        min="{{$minimum_worker_ads}}" 
                        required
                        oninput="calculateCost()">
                    <div class="invalid-feedback">
                        Please enter a valid number of workers.
                    </div>
                </div>
            
                <!-- Ads Show Duration -->
                <div class="col-md-3">
                    <label for="duration" class="form-label">Ads Show (Seconds)</label>
                    <input 
                        type="number" 
                        id="duration" 
                        name="duration" 
                        class="form-control" 
                        placeholder="Enter duration in seconds" 
                        min="{{$minimum_duration_ads}}" 
                        required
                        oninput="calculateCost()">
                    <div class="invalid-feedback">
                        Please enter a valid duration.
                    </div>
                </div>
            
                <!-- Cost Display -->
                <div class="col-md-12">
                    <p id="costDisplay" class="fw-bold">Total Cost: $0</p>
                    <p id="costDisplay2" class="fw-bold"></p>
                </div>
            
                <!-- Hidden Inputs -->
                <input type="hidden" name="worker_cost" id="worker_cost">
                <input type="hidden" name="duration_cost" id="duration_cost">
            
                <!-- Submit Button -->
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary w-100">Submit</button>
                </div>
            </form>
            
            <script>
                function calculateCost() {
                    // Get worker and duration values
                    const worker = parseInt(document.getElementById('worker').value) || 0;
                    const duration = parseInt(document.getElementById('duration').value) || 0;
                
                    // Define cost per worker and per duration
                    const costPerWorker = {{$minimum_cost_per_worker}};
                    const costPerDuration = {{$minimum_cost_per_duration}};
                    const commission = {{$commission}}; // Commission percentage (e.g., 10 for 10%)
                
                    // Calculate base cost
                    const baseCost = (worker * costPerWorker) + (duration * costPerDuration);
                    const perworkercost = baseCost / worker;
                
                    // Calculate total cost including commission (VAT)
                    const totalCost = baseCost + (baseCost * commission / 100);
                
                    // Update cost display
                    document.getElementById('costDisplay').textContent = `Total Cost with VAT: $${totalCost.toFixed(4)}`;
                    document.getElementById('costDisplay2').textContent = `Per Worker Earn: $${perworkercost.toFixed(4)}`;
                
                    // Update hidden input fields
                    document.getElementById('worker_cost').value = (worker * costPerWorker).toFixed(2);
                    document.getElementById('duration_cost').value = (duration * costPerDuration).toFixed(2);
                }

            
                function validateForm() {
                    // Ensure worker and duration values are valid
                    const worker = document.getElementById('worker').value;
                    const duration = document.getElementById('duration').value;
            
                    if (worker < {{$minimum_worker_ads}}) {
                        alert('Worker count must be at least {{$minimum_worker_ads}}.');
                        return false;
                    }
            
                    if (duration < {{$minimum_duration_ads}}) {
                        alert('Duration must be at least {{$minimum_duration_ads}} seconds.');
                        return false;
                    }
            
                    return true; // Allow form submission if validation passes
                }
            </script>
        </div>
<div class="container my-4">
    <!-- Table Wrapper -->
    <div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">My Ads List</h5>
            </div>
            <div class="card-body">
                <!-- Table Wrapper for Responsiveness -->
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover text-center align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>Published Date</th>
                                <th>Ads ID</th>
                                <th>Per Worker Cost</th>
                                <th>Worker</th>
                                <th>Clicks</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($data as $sl => $ads)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $ads->created_at->format('d M Y | h:i A') }}</td>
                                    <td>{{ $ads->slug }}</td>
                                    <td>{{ number_format($ads->cost / $ads->worker, 4) }}$</td>
                                    <td>{{ $ads->worker }}</td>
                                    <td>{{ $ads->worker_confirmed }}</td>
                                    <td>
                                            @if($ads->worker == $ads->worker_confirmed)
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check-circle"></i> Complete
                                                </span>
                                            @else
                                                <span class="badge bg-warning text-dark">
                                                    <i class="fas fa-spinner fa-spin"></i> Ads Running
                                                </span>
                                            @endif
                                    </td>
                                    <td>
                                        <a href="{{url('user/ads-history_buyer', $ads->slug)}}" class="btn btn-success btn-sm">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="text-danger">No ads found!</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</div>




<!-- Optional: Pagination -->
<div class="d-flex justify-content-center mt-3">
<div class="d-flex justify-content-center">
   {{ $data->links() }}
</div>

    </div>
</section>
@endsection

